#include <iostream>
#include <vector>
#include <unordered_map>
#include <algorithm>
#include <map>

using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    vector<long long> a(n);
    for (long long& x : a) cin >> x;

    vector<long long> prefix(n + 1, 0);
    unordered_map<long long, int> first;
    unordered_map<long long, int> last;
    unordered_map<long long, vector<int>> pos; // pozicije svakog broja
    unordered_map<long long, int> globalFreq; // ukupna frekvencija

    for (int i = 0; i < n; ++i) {
        prefix[i + 1] = prefix[i] + a[i];
        pos[a[i]].push_back(i);
        globalFreq[a[i]]++;
    }

    for (int i = 0; i <= n; ++i) {
        if (!first.count(prefix[i])) first[prefix[i]] = i;
        last[prefix[i]] = i;
    }

    int answer = 0;

    // Proveri samo najduzi podniz po prefix sumi (brzi deo, 40p tacno)
    for (const auto& [sum, l] : first) {
        int r = last[sum];
        if (r - l <= 0) continue;

        unordered_map<long long, int> freq;
        int maxFreq = 0;
        for (int k = l; k < r; ++k) {
            freq[a[k]]++;
            maxFreq = max(maxFreq, freq[a[k]]);
        }

        answer = max(answer, maxFreq);
    }

    // Dodatno proveri sve brojeve koji se pojavljuju >= 2 puta (tacnost za 25p test)
    for (const auto& [val, indices] : pos) {
        if (globalFreq[val] < 2) continue;

        map<long long, int> seenPrefix;
        for (int i = 0; i <= n; ++i) {
            seenPrefix[prefix[i]] = i;
        }

        int m = indices.size();
        for (int i = 0; i < m; ++i) {
            for (int j = i + 1; j < m; ++j) {
                int l = indices[i];
                int r = indices[j];
                if (prefix[r + 1] - prefix[l] == 0) {
                    int cnt = j - i + 1;
                    answer = max(answer, cnt);
                }
            }
        }
    }

    cout << answer << '\n';
    return 0;
}